-- Sum the vintage weight multiplied version of the annual results created in the previous step, 
--  Also, add the New vintage results from the measure impacts table as the final vintage.
--  Note: results from this query form the starting point for the final results table, to be augmented with 
--        additional results from subsequent queries.
DROP TABLE IF EXISTS meas_impacts_statewide;

CREATE TABLE meas_impacts_statewide (
  EnergyImpactID TEXT NOT NULL,
  Version TEXT,
  VersionSource TEXT,
  LastMod TEXT,
  PA TEXT NOT NULL,
  BldgType TEXT NOT NULL,
  BldgVint TEXT NOT NULL,
  BldgLoc TEXT NOT NULL,
  BldgHVAC TEXT NOT NULL,
  NormUnit TEXT,
  NumUnit REAL,
  MeasArea NUMERIC,
  ScaleBasis TEXT,
--PreWBkWh REAL,
--PreWBkW25 REAL,
--PreWBkW49 REAL,
--PreWBthm REAL,
--StdWBkWh REAL,
--StdWBkW25 REAL,
--StdWBkW49 REAL,
--StdWBthm REAL,
--MsrWBkWh REAL,
--MsrWBkW25 REAL,
--MsrWBkW49 REAL,
--MsrWBthm REAL,
  APreWBkWh REAL,
  APreWBkW REAL,
  APreWBtherm REAL,
  AStdWBkWh REAL,
  AStdWBkW REAL,
  AStdWBtherm REAL,
  "Note1" TEXT,
  PRIMARY KEY ("EnergyImpactID", "PA", "BldgType", "BldgVint", "BldgLoc", "BldgHVAC")
);


INSERT INTO meas_impacts_statewide
SELECT
"EnergyImpactID",
"Version",
"VersionSource",
datetime('now') as "LastMod",
"Statewide - Any" as "PA",
"BldgType",
era as "BldgVint",
"BldgLoc",
"BldgHVAC",
"NormUnit",
CAST(Sum("NumUnit")     / Sum(wt_vint) as REAL) AS "NumUnit",
CAST(Sum("MeasArea")    / Sum(wt_vint) as REAL) AS "MeasArea",
'None' as "ScaleBasis",
ROUND(CAST(Sum("APreWBkWh")   / Sum(wt_vint) as REAL), 4) as "APreWBkWh",
ROUND(CAST(Sum("APreWBkW")    / Sum(wt_vint) as REAL), 4) as "APreWBkW",
ROUND(CAST(Sum("APreWBtherm") / Sum(wt_vint) as REAL), 4) as "APreWBtherm",
ROUND(CAST(Sum("AStdWBkWh")   / Sum(wt_vint) as REAL), 4) as "AStdWBkWh",
ROUND(CAST(Sum("AStdWBkW")    / Sum(wt_vint) as REAL), 4) as "AStdWBkW",
ROUND(CAST(Sum("AStdWBtherm") / Sum(wt_vint) as REAL), 4) as "AStdWBtherm",
"Note1"
from meas_impacts_tmp
GROUP BY
"EnergyImpactID",
-- Don't group by PA, but sum over multiple PAs.
--"PA",
"BldgType",
era,
"BldgLoc",
"BldgHVAC",
"NormUnit"

UNION
SELECT
"EnergyImpactID",
"Version",
"VersionSource",
"LastMod",
"Statewide - Any" as "PA",
meas_impacts."BldgType",
'new' as "BldgVint",
meas_impacts."BldgLoc",
meas_impacts."BldgHVAC",
"NormUnit",
"NumUnit",
"MeasArea",
'None' as "ScaleBasis",
ROUND("APreWBkWh"  , 4),
ROUND("APreWBkW49" , 4) as "APreWBkW",
ROUND("APreWBtherm", 4),
ROUND("AStdWBkWh"  , 4),
ROUND("AStdWBkW49" , 4) as "AStdWBkW",
ROUND("AStdWBtherm", 4),
"Note1"
FROM meas_impacts
WHERE meas_impacts."BldgVint" in ('2020','MH15')

ORDER BY 
"EnergyImpactID",
"PA",
"BldgType",
"BldgVint",
"BldgLoc",
"BldgHVAC";

